/************** Projet TeX-talk **************
 * Le but de ce projet est de crer un systme de talk
 * permettant l'utilisation de commandes LaTeX
 *
 * Dveloppement, phase 1.C (cf. rapport de spec)
 * 2002 Nicolas Bernard
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "pathnames.h"

char *
nom_tex_fifo(int n)
{
        static char buffer[257] = {0};
	int i;
	for (i = 0; i < 257; i++)
	  buffer[i] = 0;
	strncat(buffer, FIFO_TEX, 100);
	strncat(buffer, getenv("LOGNAME"), 20);
	switch (n) {
	case 0:
	    strncat(buffer, "-fifo.tex", 10);
	    break;
	case 1:
	    strncat(buffer, "-fifo.log", 10);
	    break;
	case 2:
	    strncat(buffer, "-fifo.aux", 10);
	    break;
	}
	return buffer;
}

static char *
nom_dvi_fifo()
{
        static char buffer[257] = {0};
	static int fait = 0;
	if (!fait) {
	    strncat(buffer, FIFO_DVI, 100);
	    strncat(buffer, getenv("LOGNAME"), 20);
	    strncat(buffer, "-fifo.dvi", 10);
	    fait = 1;
	}
	return buffer;
}

static char *
nom_dvi()
{
        static char buffer[257] = {0};
	static int fait = 0;
	if (!fait) {
	    strncat(buffer, EMPTY_DVI_PATH, 100);
	    strncat(buffer, getenv("LOGNAME"), 20);
	    strncat(buffer, ".dvi", 6);
	    fait = 1;
	}
	return buffer;
}

/*
 * cette fonction cre les deux tubes nomms utiliss pour communiquer avec latex et
 * dvichop.
 */
static int
creer_fifos()
{
        unlink(nom_tex_fifo(0));
	unlink(nom_dvi_fifo());
	if (mkfifo (nom_tex_fifo(0), 0770) == -1) {
		perror ("Erreur fatale: cration du fifo tex impossible:");
		return -1;
	}
	if (mkfifo (nom_dvi_fifo(), 0770) == -1) {
		perror ("Erreur fatale: cration du fifo dvi impossible:");
		return -1;
	}
	return 0;
}


/*
 * Cette fonction cre le fichier dvi vide utilis au lancement de xdvi, le dplace au bon
 * endroit, puis efface le fichier de log que TeX a cr.
 */
static int
creer_dvi_vide()
{
	int pid = fork(), v = 0;
	if (!pid) {
	        close(STDOUT_FILENO);
		execlp(TEX_PATH, "tex", "\\relax\\shipout\\hbox{}\\end", NULL);
	} else if (pid == -1) {
		perror ("Erreur");
		return -1;
	}
	wait(NULL);
	v = link(TEXPUT, nom_dvi());
	if (v == -1) {
		perror ("Erreur: link texput");
		return -1;
	}
	v = unlink(TEXPUT);
	if (v == -1) {
		perror ("Erreur: Unlink texput.dvi");
		return -1;
	}
	v = unlink(TEXPUT_LOG);
	if (v == -1) {
		perror ("Erreur: Unlink texput.log");
		return -1;
	}
	return 0;
  
}

/*
 * Cette fonction est appele  la fin du programme: elle tue les processus crs et 
 * efface les fichiers temporaires.
 */
int
cleaner(int pid_xdvi, int pid_latex, int pid_dvichop)
{
	int v = 0, v2 = 0;
	kill(pid_dvichop, SIGTERM);
	kill(pid_latex, SIGTERM);
	kill(pid_xdvi, SIGTERM);
	v = unlink(nom_dvi_fifo());
	if (v == -1) {
		perror ("Erreur: Unlink dvi_fifo");
		v2 = -1;
	}
	v = unlink(nom_tex_fifo(0));
	if (v == -1) {
		perror ("Erreur: Unlink tex_fifo");
		v2 = -1;
	}
	v = unlink(nom_dvi());
	if (v == -1) {
		perror ("Erreur: Unlink dvi");
		v2 = -1;
	}
	v = unlink(nom_tex_fifo(1));
	if (v == -1) {
		perror ("Erreur: Unlink log");
		v2 = -1;
	}
	v = unlink(nom_tex_fifo(2));
	if (v == -1) {
		perror ("Erreur: Unlink aux");
		v2 = -1;
	}
	waitpid(pid_latex, NULL, 0);
	return v2;
}

int
lancer_dvichop()
{
	int pid = fork();
        if (!pid) {
		dup2(STDERR_FILENO, STDOUT_FILENO);
		execlp(DVICHOP_PATH, "dvichop", nom_dvi_fifo(), NULL);
	} else if (pid == -1) {
		perror ("Erreur fatale: dvichop");
		return -1;
	}
	waitpid(pid, NULL, WNOHANG);
	return pid;
}

int
lancer_xdvi()
{
	int pid = fork();
	if (!pid) {
#ifndef DEBUG
		close(STDOUT_FILENO);
#endif /* !DEBUG */
		execlp(XDVI_PATH, "xdvi", nom_dvi(), NULL);
	} else if (pid == -1) {
		perror ("Erreur fatale");
		return -1;
	}
	waitpid(pid, NULL, WNOHANG);
	return pid;
}

int
lancer_latex()
{
	int pid = fork();
        if (!pid) {
#ifndef DEBUG
		close(STDOUT_FILENO);
#endif /* !DEBUG */
		execlp(LATEX_PATH, "latex", "-ipc",
		       "\\nonstopmode\\input", nom_tex_fifo(0), NULL);
	} else if (pid == -1) {
		perror ("Erreur fatale");
		return -1;
	}
	waitpid(pid, NULL, WNOHANG);
	return pid;
}

int
init (int* pxdvi, int* pltx, int* pdvich)
{
        chdir("/tmp/ttalk");
	creer_fifos();
	creer_dvi_vide();
	*pdvich = lancer_dvichop();
	*pxdvi = lancer_xdvi();
	*pltx = lancer_latex();
	return 0;
}

