/************** Projet TeX-talk **************
 * Le but de ce projet est de crer un systme de talk
 * permettant l'utilisation de commandes LaTeX
 *
 * Dveloppement, phase 1.C (cf. rapport de spec)
 * 2002 Nicolas Bernard
 */

#include <sys/types.h>
#include <sys/wait.h>

#include <pthread.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "pathnames.h"
#include "launcher.h"
#include "callee.h"
#include "connect.h"
#include "params.h"

#define NB_LINES 10

struct param {
        int sock;
        FILE* fifo_tex;
        int pid_xdvi;
        pthread_mutex_t mutex;
        char **line;
};

int Dcal(char *tab[NB_LINES]) 
{
        int i;
	free(tab[0]);
	for (i = 0; i < NB_LINES - 1; i++) {
	    tab[i] = tab[i+1];
	}
	tab[NB_LINES - 1] = NULL;
	return 0;
}

void
pushfile(FILE *from, FILE* to)
{
	char buffer[300];
	char *ptr = buffer;
	while(ptr) {
		ptr = fgets(buffer, 300, from);
		fputs (buffer, to);
		fflush(to);
		buffer[0] = 0;
	}
	fprintf(to, "\n");
	fflush(to);
}

int 
initex(FILE *tube)
{
	FILE *initdata;
	char mode[10] = "read";
	initdata = fopen(INI_PATH, mode);
	pushfile(initdata, tube);
	fclose(initdata);
	return 0;
}

int
inipage(FILE *tube, int pid_xdvi)
{
	FILE *initpdata;
	char mode[10] = "read";
	initpdata = fopen(INIP_PATH, mode);
	pushfile(initpdata, tube);
	fclose(initpdata);
	return 0;
}

int
endpage(FILE *tube, int pid_xdvi)
{
	FILE *endpdata;
	char mode[10] = "read";
	endpdata = fopen(ENDP_PATH, mode);
	pushfile(endpdata, tube);
	fclose(endpdata);
	fprintf(tube, "\\eop{%d}{%d}\n", 0, pid_xdvi);
	fflush(tube);
	return 0;
}

char *
read_line(FILE* from)
{
	int val = 0, taille = 0, i = 0;
	char c = 1;
	int st = 0;
	char *buf;
	char buff[2000];
	char amettre[10] = "\\item[";
	char amettre2[10] = ":] ";
	char *name = getenv("LOGNAME");  /* System V */
	if (name == NULL)
	  name = getenv("USER");   /* BSD */

	while (amettre[taille]) {
	    buff[taille] = amettre[taille];
	    taille++;
	}

	/* sortir ces trucs de facon  ne le faire qu'une fois
	 *  l'initialisation */

	while (name[i]) {
	    buff[taille++] = name[i++];
	}
	i = 0;
	while (amettre2[i]) {
	    buff[taille++] = amettre2[i++];
	}

	st = taille;
	while ((c != 0) && (c != '\n') && (c != EOF) && (taille < 2000 - 1)) {
		val = fread(&c, 1, 1, from);
		buff[taille] = c;
		taille = taille + val;
	}
	buff[taille - 1] = 0;
	if (buff[0 + st] == '\\' && buff[1 + st] == 'q' && buff[2 + st] == 0)
			return NULL;
	buf = malloc(taille * sizeof(char));
	for (i = 0; i < taille; i++)
	    buf[i] = buff[i];
	return buf;
}

void
affiche(char **p, FILE* where, int pid_xdvi)
{
        int i;
	inipage(where, pid_xdvi);
	for (i = 0; i < NB_LINES; i++) {
	    if (p[i] != NULL)
	        fprintf(where, "\\item %s\n", p[i]);
	}
	fflush(where);
	endpage(where, pid_xdvi);
	sleep(1);
}


void*
receivesock(void *p)
{
        struct param *parm;
	parm = p;
        while(1) {
	    char *bu;
	    char buff[2000];
	    int i, val, taille = 0;
	    char c = 1;
	    while ((c != 0) && (c != '\n') && (c != EOF) && (taille < 2000 - 1)) {
		val = read(parm->sock, &c, 1);
		buff[taille] = c;
		taille = taille + val;
	    }
	    buff[taille - 1] = 0;
	    bu = malloc(taille * sizeof(char));
	    for (i = 0; i < taille; i++)
	        bu[i] = buff[i];
	    pthread_mutex_lock(&parm->mutex); /* Entre en zone critique */
	    Dcal(parm->line);
	    parm->line[NB_LINES - 1] = bu; 
	    affiche(parm->line, parm->fifo_tex, parm->pid_xdvi);
	    pthread_mutex_unlock(&parm->mutex); /* Sortie de zone critique */
	}
	return NULL;
}

int
main(int argc, char *argv[])
{
	char mode[10] = "write";
	int sock = 0, j;
	char *line[NB_LINES] = {NULL};
	int pid_xdvi = 0, pid_latex = 0, pid_dvichop = 0;
	FILE *fifo_tex;
	struct param args;
	pthread_t tid;
	struct callee* who = analyseparams(argc, argv);

	printf("TeX-talk version 0.1, Copyright (C) 2002 Nicolas Bernard\n"
	       "TeX-talk comes with ABSOLUTELY NO WARRANTY; for details see GPL 2.1.\n"
	       "This is free software, and you are welcome to redistribute it\n"
	       "under certain conditions; see GPL 2.1 for details.\n");

	pthread_mutex_init(&args.mutex, NULL);

	if (init(&pid_xdvi, &pid_latex, &pid_dvichop))
		return 1;

	fifo_tex = fopen(nom_tex_fifo(0), mode);
	if (!fifo_tex) {
		perror("Erreur Fatale");
		return 1;
	}

	sock = connecttoserver();
	if (sock == 1) {
	        perror("Impossible de se connecter au serveur");
		return 1;
	}

	etablishconnexion(who, sock);

	initex(fifo_tex);
	inipage(fifo_tex, pid_xdvi);
	fprintf(fifo_tex, "\\item[[\\TeX-talk]]: Prt\n");
	fflush(fifo_tex);
	endpage(fifo_tex, pid_xdvi);

	args.sock = sock;
	args.fifo_tex = fifo_tex;
	args.pid_xdvi = pid_xdvi;
	args.line = line;
	pthread_create(&tid, NULL, receivesock, &args);

	while (1) { /* boucle d'interaction */
	        int i = 0, pid = 0;
		char *l;
		/* on vrifie que tout va bien pour les fistons.. */
		pid = waitpid(-1, NULL, WNOHANG);
		if (pid == args.pid_xdvi) {
		    /* dans ce cas, on se contente de relancer xdvi */
		    args.pid_xdvi = lancer_xdvi();
		} else if (pid == pid_latex) {
		  /* si LaTeX est mort, on flushe les lignes de code TeX que l'on
		     a au cas ou l'une d'elle aurait plante TeX et on le relance */
		    kill(pid_dvichop, SIGTERM);
		    for (i = 1; i <= 10; i++)
		        Dcal(args.line);
		    pid_dvichop = lancer_dvichop();
		    pid_latex = lancer_latex();
		    initex(args.fifo_tex);
		} else if (pid == pid_dvichop) {
		    /* si dvichop  plant, il y a toutes les chances que TeX aussi a cause
		       d'un broken pipe. On envoie un kill sur son pid  tout hasard avant 
		       de le relancer */
		    kill(pid_latex, SIGTERM);
		    for (i = 1; i <= 10; i++)
		        Dcal(args.line);
		    pid_dvichop = lancer_dvichop();
		    pid_latex = lancer_latex();
		    initex(args.fifo_tex);
		} else {
		  /* Houston, we have a problem... */
		}
		l = read_line(stdin);
		if (l == NULL)
			break;
		pthread_mutex_lock(&args.mutex); /* Entre en zone critique */
		Dcal(args.line);
		line[NB_LINES - 1] = l;
		affiche(args.line, args.fifo_tex, args.pid_xdvi);
		i = 0;
		while (l[i]) {
		    write(sock, &l[i], 1);
		    i++;
		}
		write(sock, &l[i], 1);
		pthread_mutex_unlock(&args.mutex); /* Sortie de zone critique */
	}

	/* On nettoie tout */
	pthread_kill(tid, SIGTERM);
	close(sock);
	fclose(fifo_tex);
	if (cleaner(pid_xdvi, pid_latex, pid_dvichop))
		return 1;
	for (j = 0; j < NB_LINES; j++) 
	    if (line[j] != NULL)
	        free(line[j]);
	return 0;
}
