/*
 * TeX-talk project
 * TeX-talk Daemon v0.1 (C) 2002 Nicolas Bernard
 */

#include <assert.h>
#include <netdb.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <sys/wait.h>

#include "data.h"
#include "erreur.h"

/* this define is not an aberration. It can be usefull if using Unicode */
#define SIZECHAR 1  /* don't modify */

extern void list_add (struct data *elt);
extern int list_rem (struct data *elt);
extern struct data* searchByRname(char *);
extern void list_list();

extern int h_errno;
extern int* soc;

/*
 * this function check that the RFU field is well-formated
 * and skip it because it is not used in the version 1
 */
int
rfu(struct data * arg)
{
        short buf = 0;
        char nombre[11];
	int i = 0, r = 0;
	unsigned long n = 0;

	nombre[10] = 0;
	for(i = 0; i < 10; i++) {
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	    if (r == -1)
	        return 1;
	    if (buf == '$')
	        break;
	    else
	        nombre[i] = buf;
	}
	if (i != 0)
	    n = strtol(nombre, (char **)NULL, 10);
	for (i = 0; i < n; i++) {
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	    if (r == -1 )
	        return 1;
	  /* on ne fait rien dans la version 1.0 du protocole */
	}
	r = read(arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r == -1 )
	    return 1;
	return 0;
}

void*
communique(void* argu)
{
        struct data2* arg = argu;
        short buf = 0;
        while (1) {
	    int r;
	    r = read( arg->de, &buf, SIZECHAR);
	    if (r > 0) {
		write(arg->vers, &buf, SIZECHAR);
	    }
	    else
	        break;
	}
	return NULL;
}

int
connectToRemote(struct data * arg)
{
       struct hostent *server = gethostbyname(arg->hostname);
       struct sockaddr addr;
       socklen_t lg1;
       int i = 0, j = 0;
       struct sockaddr_in servaddr;
       struct sockaddr *saddr = (struct sockaddr *) &servaddr;
       char buf[MAX_NAME_SIZE * 2 + 10];

       if (server == NULL)
	   switch (h_errno) { /* Erreur dans la rsolution de nom ? */
	   case HOST_NOT_FOUND:
	       senderror(arg->nouvelle, 22);
	       return 1;
	       break;
	   case NO_ADDRESS:
	       senderror(arg->nouvelle, 23);
	       return 1;
	       break;
	   case NO_RECOVERY:
	       senderror(arg->nouvelle, 24);
	       return 1;
	       break;
	   case TRY_AGAIN:
	       senderror(arg->nouvelle, 25);
	       return 1;
	       break;
	   default: break;
	   }

       arg->vers = socket (PF_INET, SOCK_STREAM, 0);
       if (arg->vers < 0) {
	   senderror(arg->nouvelle, 26);
           return 1;
       }
       if (getsockname(arg->vers , &addr , &lg1 ) < 0) {
	   senderror(arg->nouvelle, 27);
           return 1;
       }
       if (bind (arg->vers, &addr, lg1) < 0) {
	   senderror(arg->nouvelle, 28);
           return 1;
       }

       servaddr.sin_family = AF_INET;
       servaddr.sin_port = htons(2002);    /* port 2002 */
       memcpy(&servaddr.sin_addr.s_addr, server->h_addr, server->h_length);
       if (connect(arg->vers, saddr, sizeof(struct sockaddr_in)) < 0) {
	   senderror(arg->nouvelle, 29);
           return 1;
       }

       buf[i++] = '$';
       for (j = 0; j <= MAX_NAME_SIZE; j++) { /* notre nom */
	 if (arg->name[j] == 0) {
	   i--;
	   break;
	 }
	 buf[i++] = arg->name[j];
       }
       buf[++i] = '$'; /* on appelle */
       buf[++i] = '0';
       buf[++i] = '$';
       i++;
       for (j = 0; j <= MAX_NAME_SIZE; j++) { /* nom appel */
	   if (arg->rname[j] == 0) {
	       i--;
	       break;
	   }
	   buf[i++] = arg->rname[j];
       }
       buf[++i] = '$';
       buf[++i] = '$'; /* rien dans RFU */
       buf[++i] = '$';
       buf[++i] = '$';
       write(arg->vers, &buf, i + 1);

       return 0;
}

int
connectToLocal(struct data *arg)
{
        sigset_t usr1;
	int signal;
	int val = 0;
	int pid = 0;
	int desc[2];
	int v = 0;

	/* 
	 * il faut envoyer une notification  l'utilisateur s'il n'est pas 
	 * dj connect. S'il l'est on renvoie au caller un msg "occup".
	 * Puis aprs l'envoi de la notification, on s'endort 1 ou 2 minutes
	 * si aprs ce temps, rien ne s'est pass, on envoie au caller "pas
	 * de rponse". Si on reoit SIGUSR1, alors la comm peut commencer
	 */
	/* ne pas oublier de vrifier que l'utilisateur existe ! */
	
	sigaddset(&usr1, SIGUSR1);

	
	pipe(desc);
	pid = fork();
	if (!pid) {
	    int a = 0;
	    if (pid == -1) {
	        perror("write fork");
		return 1;
	    }
	    /* Il faudrait remplacer cet appel  write par une 
	     * lecture de /proc et une criture directe sur le terminal de l'utilisateur */
	    close(*soc);
	    close(arg->nouvelle);
	    close(desc[1]);
	    dup2(desc[0], STDIN_FILENO);
	    a = execlp("write", "write", arg->rname, NULL);
	    if (a == -1) {
	        perror("execlp");
	    }
	    exit(1);
	} else {
	    close(desc[0]);
	    write(desc[1],
		  "*** Message du dmon TeX-talk ***\n"
		  "Vous avez un appel TeX-talk.\n"
		  "Rpondez en tapant \"ttalk\"\n",
		  90);
	    close(desc[1]);
	    waitpid(pid, &v, 0); /* faut il un WNOHANG ? */
	    if (v == -1) {
	        senderror(arg->nouvelle, 31);
		return 1;
	    }
	}

	val = sigwait(&usr1, &signal);
	if (signal == SIGUSR1) {
	    senderror(arg->vers, -1); /* pas d'erreur */
	    senderror(arg->nouvelle, -1);
	    return 0;
	} else {
	    senderror(arg->nouvelle, 30);
	    return 1;
	}
}

/* vrifie le formatage si on appelle qqn */
static int
call(struct data * arg)
{
        short buf = 0;
	int i = 0;
	int r = 0;

	arg->hostname[MAX_HOSTNAME_SIZE] = 0;
	arg->rname[MAX_NAME_SIZE] = 0;
	
	r = read(arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r == -1 ) {
	    senderror(arg->nouvelle, 1);
	    return 1;
	}

	/* le nom de login (la pers que l'on appelle) sur l'hote */
	for (i = 0; i < MAX_NAME_SIZE; i++) {
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	    if (r == -1) {
	        senderror(arg->nouvelle, 2);
	        return 1;
	    }
	    if (buf == '$')
	        break;
	    else
	        arg->rname[i] = buf;
	}
	arg->rname[i] = 0;
	if (i == MAX_NAME_SIZE)
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r == -1 || i == 0) {/* notons que le nom de login distant ne peut tre nul */
	    senderror(arg->nouvelle, 20);
	    return 1;
	}

	/* le nom de l'hote */
	for (i = 0; i < MAX_HOSTNAME_SIZE; i++) {
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	    if (r == -1) {
	        senderror(arg->nouvelle, 2);
	        return 1;
	    }
	    if (buf == '$')
	        break;
	    else
	        arg->hostname[i] = buf;
	}
	arg->hostname[i] = 0;
	if (i == MAX_HOSTNAME_SIZE)
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r ==-1) {
	    senderror(arg->nouvelle, 21);
	    return 1;
	}

	if (rfu(arg)) {
	    senderror(arg->nouvelle, 5);
	    return 1;
	}

	if (arg->hostname[0]) {
	    return (connectToRemote(arg));
	} else { 
	    return (connectToLocal(arg));
	}
}

/* tablit la connexion si on rpond  un appel */
static int
receive(struct data * arg)
{
        int r = 0;
	short buf = 0;
	struct data* caller;

	list_list();
        r = read(arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r == -1 ) {
	    senderror(arg->nouvelle, 1);
	    return 1;
	}
	if (rfu(arg)) {
	    senderror(arg->nouvelle, 5);
	    return 1;
	}

	caller = searchByRname(arg->name);
	if (caller == NULL || caller == arg) {
	    senderror(arg->nouvelle, 10);
	    return 1;
	 } else {
	     if (caller->vers != 0) {
	         senderror(arg->nouvelle, 11);
	         return 1;
	     }
	     /*
	      * ATTENTION: PB si on modifie le truc quand l'autre
	      * thread supprime l'elt => ajouter une prise du mutex
	      */
	     caller->vers = arg->nouvelle;
	     pthread_kill(caller->tid, SIGUSR1); /* on envoie un signal
						   au thread appelant pour lui
						   dire qu'il peut y aller */

	     write(arg->nouvelle, "OK\n", 3);
	     pthread_mutex_unlock(&arg->mutex); 
	     pthread_mutex_destroy(&arg->mutex);
	     assert(list_rem(arg) != 1);
	     pthread_exit(NULL);
	}
}

/* connexion initiale: tablit le type de connexion */
int
etablit(struct data * arg)
{
        short buf = 0;
	int i = 0, r = 0;
	arg->name[MAX_NAME_SIZE] = 0;

	/* we must receive a dollar first... */
	r = read(arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r == -1 ) {
	    senderror(arg->nouvelle, 1);
	    return 1;
	}

	/* ... puis un nom de taille max MAX_NAME_SIZE suivit d'un dollar... */
	for (i = 0; i < MAX_NAME_SIZE; i++) {
	    r = read(arg->nouvelle, &buf, SIZECHAR);
	    if (r != SIZECHAR) {
	        senderror(arg->nouvelle, 2);
	        return 1;
	    }
	    if (buf == '$') {
	        break;
	    } else
	        arg->name[i] = buf;
	}
	if (i == MAX_NAME_SIZE)
	    r = read( arg->nouvelle, &buf, SIZECHAR);
	if (buf != '$' || r == -1) {
	    senderror(arg->nouvelle, 3);
	    return 1; /* E03 */
	}

	/* ... puis 0 ou 1 selon que l'on appelle ou que l'on rpond... */
	r = read( arg->nouvelle, &buf, SIZECHAR);
	if (r == -1) {
	    senderror(arg->nouvelle, 2);
	    return 1;
	}
	switch (buf) {
	case '0': i = call(arg); break;
	case '1': i = receive(arg); break;
	default: return 1; /* E04 */
	}

        return i;
} 

void* commu(void * arg)
{
        struct data *elt = (struct data *) arg;
	pthread_mutex_lock(&elt->mutex);

	if (etablit(elt)) { /* si on choue */
	  close(elt->nouvelle);
	  close(elt->vers);
	  pthread_mutex_unlock(&elt->mutex);
	  pthread_mutex_destroy(&elt->mutex);
	} else { /* si on russit */
	  int pnum;
	  pthread_t tid;
	  struct data2 argu;
	  struct data2 argu2;
	  argu.de = elt->nouvelle;
	  argu.vers = elt->vers;
	  argu2.de = elt->vers;
	  argu2.vers = elt->nouvelle;
	 
	  pnum = pthread_create(&tid, NULL, communique, &argu);
	   if (pnum == 0) {
               communique(&argu2);
	       pthread_join(tid, NULL);
	       close(elt->nouvelle);
	       close(elt->vers);
	       pthread_mutex_unlock(&elt->mutex);
	       pthread_mutex_destroy(&elt->mutex);
           }
	   
	}
	assert(list_rem(elt) != -1);
	return NULL;
}
