/*
 * TeX-talk project
 * TeX-talk Daemon v0.1 (C) 2002 Nicolas Bernard
 */

#include <assert.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>

/*
 *********************************************************
 * IMPORTANT: la compilation doit se faire avec l'option *
 * -DUSE_THREAD, la version utilisant des processus      *
 * distincts  la place des threads tant OBSOLETE.*
 *********************************************************
*/

/*
 * IMPORTANT: the compilation must be done with the option
 * -DUSE_THREAD. The other version is obsolete.
 */

#ifdef USE_THREADS
#include <pthread.h>
#endif

#include "data.h"
#include "connex.h"

#define PORT 2002
#define MAX_PATH_LEN 20 /* toujours <= 108 */

struct data* list;    /* liste des connexions en cours */
pthread_mutex_t list_mutex;

int *soc;

/*
 * ajoute un lment dans la liste 
 */
void
list_add(struct data *elt)
{
  pthread_mutex_lock(&list_mutex);
  elt->next = list;
  list = elt;
  pthread_mutex_unlock(&list_mutex);
}

/*
 * enleve un element de la liste.
 * renvoie -1 si pas trouve, 0 sinon.
 */
int
list_rem(struct data *elt)
{
        struct data *current;
	struct data *previous = NULL;
#ifdef DEBUG	
	fprintf(stderr, "suppression de %s\n", elt->name);
#endif /* DEBUG */
	pthread_mutex_lock(&list_mutex);
	current = list;
	while (current != elt && current != NULL) {
	    previous = current;
	    current = current->next;
	}
	if (current == NULL) {
	    pthread_mutex_unlock(&list_mutex);
	    return -1;
	} else {
	    if (previous == NULL)
	        list = current->next;
	    else
	        previous->next = current->next;
	    free(current);
	    pthread_mutex_unlock(&list_mutex);
	    return 0;
	} 
}

void
list_list()
{
  struct data *current;
  if (list != NULL)
    current = list;
  else return;
  while(current->next != NULL) {
#ifdef DEBUG
    fprintf(stderr,
	    "Utilisateur %s connect sur la socket %d, avec l'utilisateur %s sur la socket %d\n",
	    current->name,
	    current->nouvelle,
	    current->rname,
	    current->vers);
#endif /* DEBUG */
    current = current->next;
  }
}

struct data *
searchByRname(char *entree)
{
        struct data *current;
	pthread_mutex_lock(&list_mutex);
	current = list;
#ifdef DEBUG
	fprintf(stderr,
		"Dans search: @current: %p; name = %s; rname = %s; nouvelle: %d; vers: %d; next = %p.\n; entre = %s", 
		current,
		current->name,
		current->rname, 
		current->nouvelle, 
		current->vers,
		current->next,
		entree);
#endif /* DEBUG */
	while (strcmp(current->rname, entree)) {
#ifdef DEBUG
	  fprintf(stderr, "Examining: %s\n", current->name);
#endif /* DEBUG */
	  if (current->next != NULL)
	    current = current->next;
	  else {
	    pthread_mutex_unlock(&list_mutex);
	    return NULL;
	  }
	}
	pthread_mutex_unlock(&list_mutex);
	return current;
}

int
main()
{
       int  pnum, sig;
       int  sockr;
       socklen_t lg1 = 10, lg2 = 0;
       int  nouvelle;
       struct sockaddr_in b;
       struct sockaddr addr2;
       struct sockaddr *addr1 = (struct sockaddr*) &b;
       sigset_t antipipe;
       struct data *argu;

       pthread_mutex_init(&list_mutex, NULL);

       printf("TeX-talk Daemon version 0.1, Copyright (C) 2002 Nicolas Bernard\n"
	      "TeX-talk Daemon comes with ABSOLUTELY NO WARRANTY; for details see GPL 2.1.\n"
	      "This is free software, and you are welcome to redistribute it\n"
	      "under certain conditions; see GPL 2.1 for details.\n");
       
       sigaddset(&antipipe, SIGPIPE);
       sig = sigprocmask(SIG_BLOCK, &antipipe, NULL);
       if (sig < 0) {
           perror ("sigprocmask: ");
           exit (1);
       }

       /* On cre la socket rezo */
       sockr  = socket (PF_INET, SOCK_STREAM, 0);
       if (sockr < 0) {
           perror ("socket rseau");
           exit (1);
       }
       if (getsockname(sockr , addr1 , &lg1 ) < 0) {
           perror ("getsockname");
           exit (1);
       }
       b.sin_port = htons(PORT);
       if (bind (sockr, addr1, lg1) < 0) {
           perror ("bind1");
           exit (1);
       }
       if (listen (sockr, 5) < 0) {
           perror ("listen");
           exit (1);
       }

       soc = &sockr;

       /* we are listening */
       while (1) {
	   argu = calloc(1, sizeof(struct data));
	   assert(argu != NULL);
#ifdef DEBUG
	   fprintf(stderr, "Allocation d'une nouvelle struct data  l'adresse %p\n", argu);
#endif /* DEBUG */
	   pthread_mutex_init(&argu->mutex, NULL);
	   pthread_mutex_lock(&argu->mutex);
	   argu->vers = 0;

           nouvelle = accept (sockr, &addr2, &lg2);
           if (nouvelle < 0) {
               perror ("accept");
               exit (1);
           }

	   argu->nouvelle = nouvelle;
	   list_add(argu);
	   list_list();
	   pnum = pthread_create(&argu->tid, NULL, commu, argu);
	   if (pnum == 0) {
	       pthread_mutex_unlock(&argu->mutex);
               continue;
           } else {
           perror ("pthread_create");
           exit (1);
	   }
       }
}
